package ru.yandex.partner.libs.i18n.testmsg;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum TestMsg implements GettextMsg {
    CPC_IN_PREMIUM_BLOCKS(msg("CPC in Premium blocks")),
    TOTAL_TEXT_TEMPLATES(msg("Total: %s text_template").plural("Total: %s text templates")),
    ACTION_FIND(msg("Search").context("Action")),

    ARCHIVE(msg("Archive")), // "Архив"
    INDOOR_ACTION_ARCHIVE(msg("Archive").context("Indoor action")), // "Заархивировать"
    DOOH_ACTION_ARCHIVE(msg("Archive").context("Dooh action")), // "Удалить"

    HAS_APPLES(msg("%s has %s apple").plural(1, "%s has %s apples").context("Math")),

    STATUS_DOES_NOT_EXIST(msg("Status \"%s\" does not exists")),

    NUMBER_FORMAT(msg("Big number %d should not be comma-separated"));

    private static final String KEYSET_NAME = "test_messages";

    private final GettextMsgPayload payload;

    TestMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

}
