package ru.yandex.partner.libs.juggler;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CheckGroup {

    @JsonProperty
    private String host;

    @JsonProperty
    private String service;

    @JsonProperty
    private String type;

    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String instance;

    private CheckGroup(String host, String service, String type, String instance) {
        this.host = host;
        this.service = service;
        this.type = type;
        this.instance = instance;
    }

    public static class Builder {
        private String host;
        private String service;
        private String type;
        private String instance;

        public Builder() {
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public CheckGroup build() {
            return new CheckGroup(host, service, type, instance);
        }
    }
}
