package ru.yandex.partner.libs.juggler;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class JugglerCheck {

    @JsonProperty
    private final String project;

    @JsonProperty
    private final String host;

    @JsonProperty
    private final String service;

    @JsonProperty("refresh_time")
    private final Long refreshTime;

    @JsonProperty
    private final Long ttl;

    @JsonProperty
    private final List<CheckGroup> children;

    @JsonProperty
    private final String aggregator;

    @JsonProperty("aggregator_kwargs")
    private final AggregatorKwargs aggregatorKwargs;

    @JsonProperty
    private final List<String> tags;

    @JsonProperty
    private final CheckMeta meta;

    @JsonProperty
    private final String pronounce;

    @JsonProperty
    private final String description;

    private JugglerCheck(Builder builder) {
        this.project = builder.project;
        this.host = builder.host;
        this.service = builder.service;
        this.refreshTime = builder.refreshTime;
        this.ttl = builder.ttl;
        this.children = builder.children;
        this.aggregator = builder.aggregator;
        this.aggregatorKwargs = builder.aggregatorKwargs;
        this.tags = builder.tags;
        this.meta = builder.meta;
        this.pronounce = builder.pronounce;
        this.description = builder.description;
    }

    public String getService() {
        return service;
    }

    public static class Builder {

        private String project;
        private String host;
        private String service;
        private Long refreshTime;
        private Long ttl;
        private List<CheckGroup> children;
        private String aggregator;
        private AggregatorKwargs aggregatorKwargs;
        private List<String> tags = new ArrayList<>();
        private CheckMeta meta;
        private String pronounce;
        private String description;

        public Builder() { }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setRefreshTime(Long refreshTime) {
            this.refreshTime = refreshTime;
            return this;
        }

        public Builder setTtl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setChildren(List<CheckGroup> children) {
            this.children = children;
            return this;
        }

        public Builder setAggregator(String aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public Builder setAggregatorKwargs(AggregatorKwargs aggregatorKwargs) {
            this.aggregatorKwargs = aggregatorKwargs;
            return this;
        }

        public Builder addTags(List<String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder setMeta(CheckMeta meta) {
            this.meta = meta;
            return this;
        }

        public Builder setPronounce(String pronounce) {
            this.pronounce = pronounce;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public JugglerCheck build() {
            return new JugglerCheck(this);
        }
    }
}
