package ru.yandex.partner.libs.juggler;

import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class JugglerCheckApiClient {

    private final WebClient webClient;

    public JugglerCheckApiClient(String baseUrl, String jugglerOAuthToken) {
        this.webClient = WebClient.builder()
                .baseUrl(baseUrl)
                .defaultHeader("Authorization", "OAuth " + jugglerOAuthToken)
                .build();
    }

    public Boolean addOrUpdateCheck(JugglerCheck check) {
        CheckAddOrUpdateResult result =  webClient.post()
                .uri(uriBuilder -> uriBuilder
                        .path("checks/add_or_update")
                        .queryParam("do", 1)
                        .build())
                .body(Mono.just(check), JugglerCheck.class)
                .retrieve()
                .bodyToMono(CheckAddOrUpdateResult.class)
                .block();

        if (result == null) {
            throw new RuntimeException("Request to juggler checks API end with null body!");
        }
        return result.getSuccess();
    }
}
