package ru.yandex.partner.libs.memcached.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.libs.memcached.MemcachedService;
import ru.yandex.partner.libs.memcached.MemcachedServiceFactory;

@Configuration
@ComponentScan(basePackages = {"ru.yandex.partner.libs.memcached"})
public class MemcachedConfiguration {
    @Bean
    public MemcachedService memcachedService(MemcachedProperty memcachedProperty) {
        return MemcachedServiceFactory.create(
                memcachedProperty.getCompressThreshold(),
                memcachedProperty.getNamespace(),
                memcachedProperty.getServerInetSocketAddresses()
        );
    }
}
