package ru.yandex.partner.libs.memcached.configuration;

import java.net.InetSocketAddress;
import java.util.List;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Override property yaml example:
 * memcached:
 * compress_threshold: 20000
 * namespace: my_namespace
 * servers:
 * - hostname: my_hostname
 * port: 11211
 */
@Component
@ConfigurationProperties("memcached")
public class MemcachedProperty {
    private int compressThreshold = 10_000;
    private String namespace = "beta";
    private List<ServerProperty> servers = List.of(
            new ServerProperty("localhost", 11211)
    );

    public int getCompressThreshold() {
        return compressThreshold;
    }

    public void setCompressThreshold(int compressThreshold) {
        this.compressThreshold = compressThreshold;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<ServerProperty> getServers() {
        return servers;
    }

    public void setServers(List<ServerProperty> servers) {
        this.servers = servers;
    }

    public InetSocketAddress[] getServerInetSocketAddresses() {
        return getServers()
                .stream()
                .map(server -> new InetSocketAddress(server.getHostname(), server.getPort()))
                .toArray(InetSocketAddress[]::new);
    }

    @Override
    public String toString() {
        return "MemcachedProperty{" +
                "compressThreshold=" + compressThreshold +
                ", namespace='" + namespace + '\'' +
                ", servers=" + servers +
                '}';
    }
}
