package ru.yandex.partner.libs.memcached;


import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;


/**
 * https://github.yandex-team.ru/partner/partner2/blob/master/lib/QBit/Application/Model/Memcached.pm#L63
 *
 * Объект для создания ключа, по которому кладется значение в memcached
 * Списано с перловой реализации
 */
public class MemcachedKeyMaker {
    private final String namespace;
    private final Base64 base64;

    public MemcachedKeyMaker(String namespace) {
        this.namespace = namespace;
        this.base64 = new Base64();
    }

    public String makeKey(String prefix, String key) {
        String encodedKey = String.join("_",
                md5hex(key),
                sha1Hex(key),
                crc32hex(key)
        );

        String suffix = suffix(key, encodedKey);
        return namespace +
                (prefix != null ? prefix + "_" : "") +
                encodedKey +
                suffix;
    }

    private String md5hex(String key) {
        return DigestUtils.md5Hex(key);
    }

    private String sha1Hex(String key) {
        return DigestUtils.sha1Hex(key);
    }

    private String crc32hex(String key) {
        CRC32 crc32 = new CRC32();
        crc32.update(key.getBytes(StandardCharsets.UTF_8));
        return Long.toHexString(crc32.getValue());
    }

    private String suffix(String key, String encodedKey) {
        String base64Str = new String(base64.encode(key.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        return base64Str.substring(0, Math.min(base64Str.length(), 200 - encodedKey.length()));
    }
}


