package ru.yandex.partner.libs.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;

import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.SerializingTranscoder;

public class MemcachedServiceFactory {
//    "memcached" : {
//        "compress_threshold" : 10000,
//        "debug" : 0,
//        "namespace" : "beta",
//        "servers" : ["localhost:11211"]
//    },


    private MemcachedServiceFactory() {
        // Factory
    }

    public static MemcachedService create(int compressThreshold, String namespace, InetSocketAddress... ia) {
        MemcachedClient memcachedClient;
        try {
            memcachedClient = new MemcachedClient(Arrays.asList(ia));
        } catch (IOException e) {
            throw new MemcachedException("Cannot create MemcachedClient", e);
        }

        SerializingTranscoder serializingTranscoder = new SerializingTranscoder(compressThreshold);
        return new MemcachedServiceImpl(memcachedClient, serializingTranscoder, new MemcachedKeyMaker(namespace));
    }
}
