package ru.yandex.partner.libs.memcached;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class MemcachedKeyMakerTest {

    @Test
    void encodeKey() {
        MemcachedKeyMaker memcachedKeyMaker = new MemcachedKeyMaker("test-namespace::");

        assertEquals(
                "test-namespace::test-prefix_" +
                        "53136271c432a1af377c3806c3112ddf_" +
                        "3acfb2c2b433c0ea7ff107e33df91b18e52f960f_" +
                        "32db1f79dGVzdC1rZXk=",
                memcachedKeyMaker.makeKey("test-prefix", "test-key")
        );
        assertEquals(
                "test-namespace::_" +
                        "53136271c432a1af377c3806c3112ddf_" +
                        "3acfb2c2b433c0ea7ff107e33df91b18e52f960f_" +
                        "32db1f79dGVzdC1rZXk=",
                memcachedKeyMaker.makeKey("", "test-key")
        );

        assertEquals(
                "test-namespace::" +
                        "53136271c432a1af377c3806c3112ddf_" +
                        "3acfb2c2b433c0ea7ff107e33df91b18e52f960f_" +
                        "32db1f79dGVzdC1rZXk=",
                memcachedKeyMaker.makeKey(null, "test-key")
        );
    }

    @Test
    void encodeKeyAvailableResourcesTest() {
        MemcachedKeyMaker memcachedKeyMaker = new MemcachedKeyMaker("beta");

        String key = memcachedKeyMaker.makeKey("available_resources", "user_id: 1048158951, roles: [2,17]");
        assertEquals("betaavailable_resources_" +
                "5aa8e8f8d6c8e1cafd43647541bf569f_45c7a94eb5933d9846a3d32a725d7d3b74ee3df6_" +
                "4f01e0d2dXNlcl9pZDogMTA0ODE1ODk1MSwgcm9sZXM6IFsyLDE3XQ==", key);

    }
}
