grammar MultistatePredicate;

parse
 : expression EOF
 ;

expression
 : IDENTIFIER                                     #identifierExpression
 | LPAREN expression RPAREN                       #parenExpression
 | NOT expression                                 #notExpression
 | left=expression AND right=expression           #andExpression
 | left=expression OR right=expression            #orExpression
 ;

AND        : A N D ;
OR         : O R ;
NOT        : N O T;
LPAREN     : '(' ;
RPAREN     : ')' ;
IDENTIFIER : [a-zA-Z_] [a-zA-Z_0-9]* ;
WS         : [ \r\t\u000C\n]+ -> skip;

fragment A : [aA];
fragment D : [dD];
fragment N : [nN];
fragment O : [oO];
fragment R : [rR];
fragment T : [tT];
