package ru.yandex.partner.libs.multistate;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;

import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.StateFlag;

public interface MultistatePredicates {

    static <T extends StateFlag> Predicate<Multistate<T>> any() {
        return multistate -> true;
    }

    static <T extends StateFlag> Predicate<Multistate<T>> empty() {
        return multistate -> multistate.getEnabledFlags().isEmpty();
    }

    static <T extends StateFlag> Predicate<Multistate<T>> has(T flag) {
        return multistate -> multistate.hasFlag(flag);
    }

    @SafeVarargs
    static <T extends StateFlag> Predicate<Multistate<T>> hasOneOf(T... flags) {
        return hasOneOf(Set.of(flags));
    }

    static <T extends StateFlag> Predicate<Multistate<T>> hasOneOf(Collection<T> flags) {
        return multistate -> flags.stream().anyMatch(multistate::hasFlag);
    }

    @SafeVarargs
    static <T extends StateFlag> Predicate<Multistate<T>> hasNoneOf(T... flags) {
        return hasNoneOf(Set.of(flags));
    }

    static <T extends StateFlag> Predicate<Multistate<T>> hasNoneOf(Collection<T> flags) {
        if (flags.isEmpty()) {
            return ignore -> true;
        }
        return hasOneOf(flags).negate();
    }

}
