package ru.yandex.partner.libs.multistate.action;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class ActionCheck<M extends Model> {
    private final Function<List<? extends M>, List<Boolean>> check;
    private final Set<ModelProperty<? super M, ?>> requiredModelProperties;

    public ActionCheck(Function<List<? extends M>, List<Boolean>> check, Set<ModelProperty<? super M, ?>> requiredModelProperties) {
        this.check = check;
        this.requiredModelProperties = requiredModelProperties;
    }

    public ActionCheck(Function<List<? extends M>, List<Boolean>> check) {
        this.check = check;
        this.requiredModelProperties = new HashSet<>();
    }

    public Function<List<? extends M>, List<Boolean>> getCheck() {
        return check;
    }

    public Set<ModelProperty<? super M, ?>> getRequiredModelProperties() {
        return requiredModelProperties;
    }
}
