package ru.yandex.partner.libs.multistate.graph;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.Action;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.libs.multistate.action.ActionEntry;

public interface MultistateGraph<M, T extends StateFlag> {

    Map<String, List<Boolean>> checkActionsAllowed(Collection<String> actionNames, List<? extends M> models);

    Map<? extends M, Boolean> isActionAllowed(String actionName, List<? extends M> models);

    List<? extends M> filteredByActionAllowed(String actionName, List<? extends M> models);

    Map<String, Boolean> checkActionsAllowed(Collection<String> actionNames, M model);

    List<Boolean> checkActionAllowed(String actionName, List<? extends M> models);

    Boolean checkActionAllowed(String actionName, M model);

    List<Set<Action>> getAllowedActions(List<? extends M> models);

    Set<Action> getAllowedActions(M model);

    Set<String> getAllAvailableActionNames();

    Map<T, Boolean> getFlagModificationsForAction(String actionName);

    Set<Multistate<T>> getReachableMultistates();

    Set<Multistate<T>> getMultistatesForPredicate(Predicate<Multistate<T>> predicate);

    Map<Multistate<T>, Map<String, Multistate<T>>> getAllTransitions();

    Set<ModelProperty<? super M, ?>> getAllRequiredProperties();

    Set<ModelProperty<? super M, ?>> getRequiredPropertiesByActionName(String actionName);

    Multistate<T> getMultistateFromModel(M model);

    Boolean containsAction(String actionName);

    ActionEntry<M, T> getActionEntry(String actionName);

    List<Long> getMultistatesByAction(String actionName);

    Class<M> getModelClass();

    Multistate<T> convertMultistate(List<T> enabledFlags);
}
