package ru.yandex.partner.libs.multistate.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum ExpressionParsingMsg implements GettextMsg {
    STATUS_DOES_NOT_EXIST(msg("Status \"%s\" does not exists")),
    SYNTAX_ERROR_IN_EXPRESSION(msg("Syntax error in expression \"%s\""));

    private static final String KEYSET_NAME = "lib__QBit__Application__Model__Multistate.pm";

    private final GettextMsgPayload payload;

    ExpressionParsingMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

}
