package ru.yandex.partner.libs.rbac.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum RoleNameMsg implements GettextMsg {
    ADFOX(msg("AdFox")),
    ASSESSOR(msg("Assessor"), "lib__Application__Model__Page__MIXIN__External.pm"),
    BUSINESS_UNIT(msg("Business unit"), "lib__Application__Model__Product__VideoAN__Site.pm"),
    DEVELOPER(msg("Developer")),
    DSP_MANAGER(msg("DSP: Manager")),
    DSP_PARTNER(msg("DSP: Partner")),
    DSP_VIEWER(msg("DSP: Viewer")),
    INDOOR_PARTNER(msg("Indoor: Partner")),
    OUTDOOR_PARTNER(msg("Outdoor: Partner")),
    ROBOT_ASSISTANT(msg("Robot assistant")),
    TUTBY_AGGREGATOR(msg("Tutby aggregator")),
    YAN_APPLICATIONS_PARTNER(msg("YAN Applications: Partner")),
    YANDEX_SERVICES_ADMINISTRATOR(msg("Yandex services: Administrator")),
    YANDEX_SERVICES_MANAGER(msg("Yandex services: Manager")),
    YANDEX_SERVICES_VIEWER(msg("Yandex services: Viewer")),
    YAN_MANAGER(msg("YAN: Manager")),
    YAN_MODERATOR(msg("YAN: Moderator")),
    YAN_SITES_ADBLOCK_PARTNER(msg("YAN Sites: AdBlock partner")),
    YAN_SITES_PARTNER(msg("YAN Sites: Partner")),
    YAN_SITES_PARTNERS_ASSISTANT(msg("YAN Sites: Partner's assistant")),
    YAN_VIDEO_PARTNER(msg("YAN Video: Partner")),
    YAN_VIEWER(msg("YAN: Viewer")),
    PROTECTED_PAGES_EDITOR(msg("Protected pages editor")),
    DISTRIBUTION_MANAGER(msg("Distribution: manager"));

    private static final String DEFAULT_KEYSET = "lib__Application__Model__RBAC.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    RoleNameMsg(GettextMsgPayload.Builder builder) {
        this(builder, DEFAULT_KEYSET);
    }

    RoleNameMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
