package ru.yandex.partner.libs.rbac.right;

import java.util.Objects;
import java.util.Set;

import ru.yandex.partner.core.role.Role;

import static com.google.common.base.Preconditions.checkNotNull;

public class Right {
    private final String name;
    // TODO: RegularEnumSet
    private final Set<Role> roles;

    public Right(String name, Set<Role> roles) {
        checkNotNull(name);
        checkNotNull(roles);
        this.name = name;
        this.roles = Set.copyOf(roles);
    }

    public String getName() {
        return name;
    }

    public Set<Role> getRoles() {
        return roles;
    }

    @Override
    public String toString() {
        return "Right{" + "name='" + name + '\'' +
                ", roleIds=" + roles +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Right right = (Right) o;
        return name.equals(right.name);
        //todo: если нужно сравнивать роли, то нужно дописать логику
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, roles);
    }
}
