package ru.yandex.partner.libs.rbac.right;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.libs.rbac.role.RoleSet;

@Repository
public class RightRepository {
    private static final String ROLE_RIGHTS_FILE_PATH = "ru/yandex/partner/libs/rbac/role_rights.ssv";
    private final Map<String, Right> rightsMap;

    public RightRepository() {
        this.rightsMap = readRightsMap();
    }

    private static Map<String, Right> readRightsMap() {
        try (InputStream inputStream = new ClassPathResource(ROLE_RIGHTS_FILE_PATH).getInputStream();
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream))) {
            return bufferedReader.lines().filter(s -> !s.startsWith("#"))
                    .map(s -> s.split("\\s+", 2))
                    .collect(
                            Collectors.toUnmodifiableMap(
                                    a -> a[0],
                                    a -> new Right(
                                            a[0],
                                            Arrays.stream(a[1].split("[\\s,]+"))
                                                    .map(Long::parseLong)
                                                    .map(RoleSet::getRoleById)
                                                    .map(Optional::get) // this will throw if role does not exist
                                                    .collect(Collectors.toUnmodifiableSet())
                                    )
                            )
                    );
        } catch (IOException e) {
            throw new RightsReadException("Exception during read role_rights.ssv", e);
        }
    }

    public Map<String, Right> getRightsMap() {
        return this.rightsMap;
    }
}
