package ru.yandex.partner.libs.rbac.right;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.role.Role;
import ru.yandex.partner.libs.rbac.role.RoleSet;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.partner.libs.rbac.constants.Constants.FAKE_LOGIN_RIGHT_NAME;
import static ru.yandex.partner.libs.rbac.constants.Constants.PRODUCTION;

@Service
public class RightService {
    private Map<String, Right> rightsMap;

    @Autowired
    public RightService(RightRepository rightRepository, Environment environment) {
        this.rightsMap = rightRepository.getRightsMap();
        Optional<String> production = Arrays.stream(environment.getActiveProfiles())
                .filter(profile -> profile.equalsIgnoreCase(PRODUCTION))
                .findAny();
        if (production.isEmpty()) {
            HashMap<String, Right> temp = new HashMap<>(rightsMap);
            Right fakeLoginRight = new Right(FAKE_LOGIN_RIGHT_NAME, Set.of(RoleSet.DEVELOPER, RoleSet.YAN_MANAGER));
            temp.put(fakeLoginRight.getName(), fakeLoginRight);
            rightsMap = temp;
        }
    }

    public Set<String> getAllRightNames() {
        return rightsMap.keySet();
    }

    public boolean isRightExists(String rightName) {
        checkNotNull(rightName);
        return rightsMap.containsKey(rightName);
    }

    private void checkRightName(String name) {
        if (!isRightExists(name)) {
            throw new RightNotExistsException(String.format("%s right not exists", name));
        }
    }

    public Right getRightByName(String rightName) {
        checkRightName(rightName);
        return rightsMap.get(rightName);
    }

    public Set<Role> getRightRoles(String rightName) {
        checkRightName(rightName);
        return rightsMap.get(rightName).getRoles();
    }

    public Map<String, Right> getRightsMap() {
        return rightsMap;
    }
}
