package ru.yandex.partner.libs.rbac.role;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.role.Role;
import ru.yandex.partner.libs.rbac.right.Right;
import ru.yandex.partner.libs.rbac.right.RightService;

@Repository
public class RoleRepository {
    private final Map<Role, Set<Right>> roleToRightsMap;

    @Autowired
    public RoleRepository(RightService rightService) {
        Map<String, Right> rightMap = rightService.getRightsMap();
        this.roleToRightsMap = Map.copyOf(
                EntryStream.of(rightService.getRightsMap())
                        .mapValues(Right::getRoles)
                        .flatMapValues(Set::stream)
                        .invert()
                        .mapValues(rightMap::get)
                        .grouping(Collectors.toUnmodifiableSet())
        );
    }

    public static Set<Role> getRoles() {
        return RoleSet.getRoles();
    }

    public Map<Role, Set<Right>> getRoleToRightsMap() {
        return roleToRightsMap;
    }
}
