package ru.yandex.partner.libs.rbac.role;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.partner.core.role.Role;
import ru.yandex.partner.libs.rbac.messages.RoleNameMsg;

import static ru.yandex.partner.libs.rbac.group.Group.GROUP_DEV;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_DSP;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_ROBOTS;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_TUTBY;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_YAN;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_YNDX_SERVICES;

public class RoleSet {
    private static final long DEVELOPER_ROLE_ID = 2;
    // {id => $DEVELOPER_ROLE_ID, name => d_gettext('Developer'), is_internal => TRUE, group => $GROUP_DEV},
    public static final Role DEVELOPER = new Role(
            DEVELOPER_ROLE_ID,
            RoleNameMsg.DEVELOPER,
            true,
            GROUP_DEV.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long INTERNAL_YAN_MANAGER_ROLE_ID = 3;
    /*
    { id => $INTERNAL_YAN_MANAGER_ROLE_ID, name => d_gettext('Yandex services: Manager'), is_internal => TRUE,
    group => $GROUP_YNDX_SERVICES }
    */
    public static final Role INTERNAL_YAN_MANAGER = new Role(
            INTERNAL_YAN_MANAGER_ROLE_ID,
            RoleNameMsg.YANDEX_SERVICES_MANAGER,
            true,
            GROUP_YNDX_SERVICES.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long INTERNAL_YAN_ADMINISTRATOR_ROLE_ID = 4;
    /*
    { id => $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID, name => d_gettext('Yandex services: Administrator'),
    is_internal => TRUE, group => $GROUP_YNDX_SERVICES }
    */
    public static final Role INTERNAL_YAN_ADMINISTRATOR = new Role(
            INTERNAL_YAN_ADMINISTRATOR_ROLE_ID,
            RoleNameMsg.YANDEX_SERVICES_ADMINISTRATOR,
            true,
            GROUP_YNDX_SERVICES.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long DSP_PARTNER_ROLE_ID = 7;
    // {id => $DSP_PARTNER_ROLE_ID, name => d_gettext('DSP: Partner'), group => $GROUP_DSP},
    public static final Role DSP_PARTNER = new Role(
            DSP_PARTNER_ROLE_ID,
            RoleNameMsg.DSP_PARTNER,
            null,
            GROUP_DSP.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long DSP_MANAGER_ROLE_ID = 8;
    // {id => $DSP_MANAGER_ROLE_ID, name => d_gettext('DSP: Manager'), is_internal => TRUE, group => $GROUP_DSP},
    public static final Role DSP_MANAGER = new Role(
            DSP_MANAGER_ROLE_ID,
            RoleNameMsg.DSP_MANAGER,
            true,
            GROUP_DSP.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long SITE_PARTNER_ROLE_ID = 9;
    /*
    { id => $SITE_PARTNER_ROLE_ID, name => d_gettext('YAN Sites: Partner'),
    related_page_accessor => [qw(context_on_site_campaign search_on_site_campaign)], group => $GROUP_YAN }
    */
    public static final Role SITE_PARTNER = new Role(
            SITE_PARTNER_ROLE_ID,
            RoleNameMsg.YAN_SITES_PARTNER,
            null,
            GROUP_YAN.getId(),
            Set.of("context_on_site_campaign", "search_on_site_campaign"),
            null,
            null,
            null,
            true,
            null
    );
    private static final long YAN_MANAGER_ROLE_ID = 15;
    //  {id => $YAN_MANAGER_ROLE_ID, name => d_gettext('YAN: Manager'), is_internal => TRUE, group => $GROUP_YAN},
    public static final Role YAN_MANAGER = new Role(
            YAN_MANAGER_ROLE_ID,
            RoleNameMsg.YAN_MANAGER,
            true,
            GROUP_YAN.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long YAN_MODERATOR_ROLE_ID = 16;
    // {id => $YAN_MODERATOR_ROLE_ID, name => d_gettext('YAN: Moderator'), is_internal => TRUE, group =>
    // $GROUP_YAN},
    public static final Role YAN_MODERATOR = new Role(
            YAN_MODERATOR_ROLE_ID,
            RoleNameMsg.YAN_MODERATOR,
            true,
            GROUP_YAN.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long YAN_VIEWER_ROLE_ID = 17;
    /*
    { id => $YAN_VIEWER_ROLE_ID, name => d_gettext('YAN: Viewer'), is_internal => TRUE, group => $GROUP_YAN,
    viewer => TRUE, conflict_role_for_set => [$YAN_MANAGER_ROLE_ID, $YAN_MODERATOR_ROLE_ID] }
    */
    public static final Role YAN_VIEWER = new Role(
            YAN_VIEWER_ROLE_ID,
            RoleNameMsg.YAN_VIEWER,
            true,
            GROUP_YAN.getId(),
            null,
            true,
            Set.of(YAN_MANAGER, YAN_MODERATOR),
            null,
            null,
            null
    );
    private static final long DSP_VIEWER_ROLE_ID = 18;
    /*
    { id => $DSP_VIEWER_ROLE_ID, name => d_gettext('DSP: Viewer'), is_internal => TRUE, group => $GROUP_DSP,
    viewer => TRUE, conflict_role_for_set => [$DSP_MANAGER_ROLE_ID] },
    */
    public static final Role DSP_VIEWER = new Role(
            DSP_VIEWER_ROLE_ID,
            RoleNameMsg.DSP_VIEWER,
            true,
            GROUP_DSP.getId(),
            null,
            true,
            Set.of(DSP_MANAGER),
            null,
            null,
            null
    );
    private static final long INTERNAL_YAN_VIEWER_ROLE_ID = 19;
    /*
    { id => $INTERNAL_YAN_VIEWER_ROLE_ID, name => d_gettext('Yandex services: Viewer'), is_internal => TRUE,
    group => $GROUP_YNDX_SERVICES, viewer => TRUE,
    conflict_role_for_set => [$INTERNAL_YAN_MANAGER_ROLE_ID, $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID] },
    */
    public static final Role INTERNAL_YAN_VIEWER = new Role(
            INTERNAL_YAN_VIEWER_ROLE_ID,
            RoleNameMsg.YANDEX_SERVICES_VIEWER,
            true,
            GROUP_YNDX_SERVICES.getId(),
            null,
            true,
            Set.of(INTERNAL_YAN_MANAGER, INTERNAL_YAN_ADMINISTRATOR),
            null,
            null,
            null
    );
    protected static final long VIDEO_PARTNER_ROLE_ID = 20;
    /*
    { id => $VIDEO_PARTNER_ROLE_ID, name => d_gettext('YAN Video: Partner'), related_page_accessor => ['video_an_site'],
    group => $GROUP_YAN },
    */
    public static final Role VIDEO_PARTNER = new Role(
            VIDEO_PARTNER_ROLE_ID,
            RoleNameMsg.YAN_VIDEO_PARTNER,
            null,
            GROUP_YAN.getId(),
            Set.of("video_an_site"),
            null,
            null,
            null,
            true,
            null
    );
    private static final long MOBILE_PARTNER_ROLE_ID = 27;
    /*
    { id => $MOBILE_PARTNER_ROLE_ID, name => d_gettext('YAN Applications: Partner'),
    related_page_accessor => ['mobile_app_settings'], group => $GROUP_YAN },
    */
    public static final Role MOBILE_PARTNER = new Role(
            MOBILE_PARTNER_ROLE_ID,
            RoleNameMsg.YAN_APPLICATIONS_PARTNER,
            null,
            GROUP_YAN.getId(),
            Set.of("mobile_app_settings"),
            null,
            null,
            null,
            true,
            null
    );
    private static final long BUSINESS_UNIT_ROLE_ID = 33;
    /*
    { id => $BUSINESS_UNIT_ROLE_ID, name => d_gettext("Business unit"), group => $GROUP_YAN,
    required_role_for_set => $SITE_PARTNER_ROLE_ID },
    */
    public static final Role BUSINESS_UNIT = new Role(
            BUSINESS_UNIT_ROLE_ID,
            RoleNameMsg.BUSINESS_UNIT,
            null,
            GROUP_YAN.getId(),
            null,
            null,
            null,
            Set.of(SITE_PARTNER),
            null,
            null
    );
    private static final long ADBLOCK_PARTNER_ROLE_ID = 36;
    /*
    { id => $ADBLOCK_PARTNER_ROLE_ID, name => d_gettext('YAN Sites: AdBlock partner'), group => $GROUP_YAN,
    required_role_for_set => $SITE_PARTNER_ROLE_ID },
    */
    public static final Role ADBLOCK_PARTNER = new Role(
            ADBLOCK_PARTNER_ROLE_ID,
            RoleNameMsg.YAN_SITES_ADBLOCK_PARTNER,
            null,
            GROUP_YAN.getId(),
            null,
            null,
            null,
            Set.of(SITE_PARTNER),
            null,
            null
    );
    private static final long YAN_PARTNER_ASSISTANT_ROLE_ID = 37;
    /*
    { id => $YAN_PARTNER_ASSISTANT_ROLE_ID, name => d_gettext("YAN Sites: Partner's assistant"),
    group => $GROUP_YAN, conflict_role_for_set => [$YAN_MANAGER_ROLE_ID, $YAN_MODERATOR_ROLE_ID, $YAN_VIEWER_ROLE_ID] },
    */
    public static final Role YAN_PARTNER_ASSISTANT = new Role(
            YAN_PARTNER_ASSISTANT_ROLE_ID,
            RoleNameMsg.YAN_SITES_PARTNERS_ASSISTANT,
            null,
            GROUP_YAN.getId(),
            null,
            null,
            Set.of(YAN_MANAGER, YAN_MODERATOR, YAN_VIEWER),
            null,
            true,
            null
    );
    private static final long TUTBY_ROLE_ID = 39;
    /*
    { id => $TUTBY_ROLE_ID, name => d_gettext("Tutby aggregator"), group => $GROUP_TUTBY },
    */
    public static final Role TUTBY = new Role(
            TUTBY_ROLE_ID,
            RoleNameMsg.TUTBY_AGGREGATOR,
            null,
            GROUP_TUTBY.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long INDOOR_PARTNER_ROLE_ID = 40;
    /*
    { id => $INDOOR_PARTNER_ROLE_ID, name => d_gettext('Indoor: Partner'),
    related_page_accessor => ['indoor'], group => $GROUP_YAN },
    */
    public static final Role INDOOR_PARTNER = new Role(
            INDOOR_PARTNER_ROLE_ID,
            RoleNameMsg.INDOOR_PARTNER,
            null,
            GROUP_YAN.getId(),
            Set.of("indoor"),
            null,
            null,
            null,
            true,
            null
    );
    private static final long ADFOX_ROLE_ID = 41;
    /*
    { id => $ADFOX_ROLE_ID, name => d_gettext('AdFox'), group => $GROUP_YAN },
    */
    public static final Role ADFOX = new Role(
            ADFOX_ROLE_ID,
            RoleNameMsg.ADFOX,
            null,
            GROUP_YAN.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );
    private static final long OUTDOOR_PARTNER_ROLE_ID = 42;
    /*
    { id => $OUTDOOR_PARTNER_ROLE_ID, name => d_gettext('Outdoor: Partner'), related_page_accessor => ['outdoor'],
    group => $GROUP_YAN },
    */
    public static final Role OUTDOOR_PARTNER = new Role(
            OUTDOOR_PARTNER_ROLE_ID,
            RoleNameMsg.OUTDOOR_PARTNER,
            null,
            GROUP_YAN.getId(),
            Set.of("outdoor"),
            null,
            null,
            null,
            true,
            null
    );


    private static final long ROBOT_ASSISTANT_ROLE_ID = 43;
    /*
     {
        id                    => $ROBOT_ASSISTANT_ROLE_ID,
        name                  => d_gettext('Robot assistant'),
        is_internal           => TRUE,
        group                 => $GROUP_ROBOTS,
        required_role_for_set => [$YAN_MANAGER_ROLE_ID, $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID],
        idm                   => 'ROBOT_ASSISTANT',
    },
    */
    public static final Role ROBOT_ASSISTANT = new Role(
            ROBOT_ASSISTANT_ROLE_ID,
            RoleNameMsg.ROBOT_ASSISTANT,
            true,
            GROUP_ROBOTS.getId(),
            null,
            null,
            null,
            Set.of(YAN_MANAGER, INTERNAL_YAN_ADMINISTRATOR),
            null,
            null
    );


    private static final long ASSESSOR_ROLE_ID = 44;
    /*
   {
        id           => $ASSESSOR_ROLE_ID,
        name         => d_gettext('Assessor'),
        all_external => TRUE,
        group        => $GROUP_YAN
    },
    */
    public static final Role ASSESSOR = new Role(
            ASSESSOR_ROLE_ID,
            RoleNameMsg.ASSESSOR,
            false,
            GROUP_YAN.getId(),
            null,
            null,
            null,
            null,
            null,
            true
    );

    private static final long PROTECTED_PAGES_EDITOR_ROLE_ID = 45;
    /*
    {
        id          => $PROTECTED_PAGES_EDITOR_ROLE_ID,
        name        => d_gettext('Protected pages editor'),
        is_internal => TRUE,
        group       => $GROUP_DEV,
        idm         => 'PROTECTED_PAGES_EDITOR',
    },
     */
    public static final Role PROTECTED_PAGES_EDITOR = new Role(
            PROTECTED_PAGES_EDITOR_ROLE_ID,
            RoleNameMsg.PROTECTED_PAGES_EDITOR,
            true,
            GROUP_DEV.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );

    private static final long DISTRIBUTION_MANAGER_ROLE_ID = 46;
    /*
    {
        id          => $DISTRIBUTION_MANAGER_ROLE_ID,
        name        => d_gettext('Distribution: manager'),
        is_internal => TRUE,
        group       => $GROUP_YAN,
        idm         => 'DISTRIBUTION_MANAGER',
    },
     */
    public static final Role DISTRIBUTION_MANAGER = new Role(
            DISTRIBUTION_MANAGER_ROLE_ID,
            RoleNameMsg.DISTRIBUTION_MANAGER,
            true,
            GROUP_YAN.getId(),
            null,
            null,
            null,
            null,
            null,
            null
    );

    private static final Set<Role> ROLES = Set.of(
            DEVELOPER,
            INTERNAL_YAN_MANAGER,
            INTERNAL_YAN_ADMINISTRATOR,
            DSP_PARTNER,
            DSP_MANAGER,
            SITE_PARTNER,
            YAN_MANAGER,
            YAN_MODERATOR,
            YAN_VIEWER,
            DSP_VIEWER,
            INTERNAL_YAN_VIEWER,
            VIDEO_PARTNER,
            MOBILE_PARTNER,
            BUSINESS_UNIT,
            ADBLOCK_PARTNER,
            YAN_PARTNER_ASSISTANT,
            TUTBY,
            INDOOR_PARTNER,
            ADFOX,
            OUTDOOR_PARTNER,
            ROBOT_ASSISTANT,
            ASSESSOR,
            PROTECTED_PAGES_EDITOR,
            DISTRIBUTION_MANAGER
    );

    private static final Map<Long, Role> ROLE_ID_TO_ROLE_MAP = ROLES.stream()
            .collect(Collectors.toUnmodifiableMap(Role::getRoleId, v -> v));

    private RoleSet() {
        // Utility class
    }

    public static Optional<Role> getRoleById(long roleId) {
        return Optional.ofNullable(ROLE_ID_TO_ROLE_MAP.get(roleId));
    }

    public static Set<Role> getRoles() {
        return ROLES;
    }
}
