package ru.yandex.partner.libs.rbac.userrole;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import ru.yandex.partner.core.role.Role;
import ru.yandex.partner.libs.rbac.right.Right;

public interface UserRoleService {

    Set<Role> getUserRoles(long userId);

    Map<Long, Set<Role>> getUserRolesMap(Collection<Long> userId);

    Set<Right> getUserRightsFromRoles(Set<Role> rolesSet);

    Set<Right> getUserRights(long userId);

    Set<String> getUserRightNames(long userId);

    boolean hasRole(long userId, Role role);

    boolean hasRoles(long userId, Set<Role> roles);

    boolean hasRight(long userId, Right right);

    boolean hasRights(long userId, Set<Right> rights);

    boolean hasRightByName(long userId, String rightName);

    boolean hasRightsByNames(long userId, Set<String> rightNames);

    void setUserRoles(long userId, Set<Role> roles);
}
