package ru.yandex.partner.libs.rbac.configuration;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.partner.test.db.MysqlTestConfiguration;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@SpringBootTest(
        properties = "spring.main.allow-bean-definition-overriding=true"
)
@ContextConfiguration(classes = {RbacConfiguration.class, MysqlTestConfiguration.class})
@EnableAutoConfiguration
@Transactional
public @interface RbacLibraryTest {
}
