package ru.yandex.partner.libs.rbac.group;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_DEV;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_DSP;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_ROBOTS;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_SSP;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_TUTBY;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_YAN;
import static ru.yandex.partner.libs.rbac.group.Group.GROUP_YNDX_SERVICES;

public class GroupTest {
    private static GroupService service;

    @BeforeAll
    static void prepare() {
        GroupRepository repository = new GroupRepository();
        service = new GroupService(repository);
    }

    @Test
    void checkGroupsCount() {
        assertThat(service.getGroups().size()).isEqualTo(7);
    }

    @Test
    void checkGroups() {
        assertThat(service.getGroups()).containsExactlyInAnyOrder(
                GROUP_DEV,
                GROUP_YNDX_SERVICES,
                GROUP_DSP,
                GROUP_YAN,
                GROUP_SSP,
                GROUP_TUTBY,
                GROUP_ROBOTS
        );
    }

    @Test
    void checkGroupExists() {
        assertThat(service.isGroupExists("GrOuP_DsP")).isTrue();
    }
    @Test
    void checkGroupNotExists() {
        assertThat(service.isGroupExists("")).isFalse();
    }
}
