package ru.yandex.partner.libs.rbac.userrole;

import java.util.Set;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.partner.libs.rbac.configuration.RbacLibraryTest;
import ru.yandex.partner.libs.rbac.role.RoleService;
import ru.yandex.partner.libs.rbac.role.RoleSet;

import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.partner.libs.rbac.role.RoleSet.ADBLOCK_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_ADMINISTRATOR;
import static ru.yandex.partner.libs.rbac.role.RoleSet.MOBILE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.ROBOT_ASSISTANT;
import static ru.yandex.partner.libs.rbac.role.RoleSet.SITE_PARTNER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.YAN_MANAGER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.YAN_MODERATOR;

@RbacLibraryTest
public class UserRoleTest {

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    RoleService roleService;

    @Test
    void checkUserRoleCount() {
        assertThat(userRoleService.getUserRoles(1016).size()).isEqualTo(2);
        assertThat(userRoleService.getUserRoles(1030).size()).isEqualTo(3);
        assertThat(userRoleService.getUserRoles(1009).size()).isEqualTo(1);
    }

    @Test
    void checkUserRoles() {
        assertThat(userRoleService.getUserRoles(1016))
                .containsExactlyInAnyOrder(RoleSet.ADBLOCK_PARTNER, SITE_PARTNER);
        assertThat(userRoleService.getUserRoles(1030))
                .containsExactlyInAnyOrder(INTERNAL_YAN_ADMINISTRATOR, YAN_MANAGER, ROBOT_ASSISTANT);
        assertThat(userRoleService.getUserRoles(1009))
                .containsExactly(SITE_PARTNER);
    }

    @Test
    void checkHasRole() {
        assertThat(userRoleService.hasRole(1016, SITE_PARTNER)).isTrue();
        assertThat(userRoleService.hasRoles(1016, Set.of(SITE_PARTNER, ADBLOCK_PARTNER))).isTrue();
        assertThat(userRoleService.hasRole(1016, YAN_MANAGER)).isFalse();
        assertThat(userRoleService.hasRoles(1016, Set.of(YAN_MANAGER, MOBILE_PARTNER))).isFalse();
        assertThat(userRoleService.hasRoles(1016, Set.of(YAN_MANAGER, YAN_MODERATOR))).isFalse();
    }

    @Test
    void checkSetRoles() {
        userRoleService.setUserRoles(1025, Set.of(SITE_PARTNER, MOBILE_PARTNER, YAN_MANAGER, YAN_MODERATOR));
        assertThat(userRoleService.getUserRoles(1025).size()).isEqualTo(4);
        assertThat(userRoleService.getUserRoles(1025))
                .containsExactlyInAnyOrder(SITE_PARTNER, MOBILE_PARTNER, YAN_MANAGER, YAN_MODERATOR);
    }
}
