package ru.yandex.partner.test.http.json.model;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;

public class MultiPointerFilter extends TokenFilter {
    private Collection<JsonPointer> pathsToMatch;

    public MultiPointerFilter(List<JsonPointer> pathsToMatch) {
        this.pathsToMatch = pathsToMatch;
    }

    @Override
    public TokenFilter includeElement(int index) {
        var nextPaths = pathsToMatch.stream()
                .map(it -> it.matchElement(index))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        if (nextPaths.isEmpty()) {
            return null;
        }
        if (nextPaths.stream().anyMatch(JsonPointer::matches)) {
            return TokenFilter.INCLUDE_ALL;
        }
        return new MultiPointerFilter(nextPaths);
    }

    @Override
    public TokenFilter includeProperty(String name) {
        var nextPaths = pathsToMatch.stream()
                .map(it -> it.matchProperty(name))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        if (nextPaths.isEmpty()) {
            return null;
        }
        if (nextPaths.stream().anyMatch(JsonPointer::matches)) {
            return TokenFilter.INCLUDE_ALL;
        }
        return new MultiPointerFilter(nextPaths);
    }

    @Override
    public TokenFilter filterStartArray() {
        return this;
    }

    @Override
    public TokenFilter filterStartObject() {
        return this;
    }

    @Override
    protected boolean _includeScalar() {
        // should only occur for root-level scalars, path "/"
        return pathsToMatch.stream().anyMatch(JsonPointer::matches);
    }

    @Override
    public String toString() {
        return "[JsonPointerFilter at: "+pathsToMatch+"]";
    }
}
