package ru.yandex.partner.test.http.json.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.partner.test.utils.TestUtils;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TestHttpCase {
    private Map<String, JsonNode> options;
    private List<TestHttpExchange> tests;

    public static TestHttpCase load(String resourcePath) throws IOException {
        ObjectMapper objectMapper = TestUtils.getObjectMapper();
        try (InputStream inputStream = TestHttpCase.class.getResourceAsStream(resourcePath)) {
            return objectMapper.treeToValue(
                    objectMapper.readValue(inputStream, JsonTestModel.class).getData(),
                    TestHttpCase.class
            );
        }
    }

    public Map<String, JsonNode> getOptions() {
        return options != null
                ? options
                : Map.of();
    }

    public void setOptions(Map<String, JsonNode> options) {
        this.options = options;
    }

    public <T> T getOption(String name, Class<T> tClass) {
        return TestUtils.parseOption(options, name, tClass);
    }

    public <T> T getOption(String name, JavaType type) {
        return TestUtils.parseOption(options, name, type);
    }

    public List<TestHttpExchange> getTests() {
        return tests;
    }

    public void setTests(List<TestHttpExchange> tests) {
        this.tests = tests;
    }
}
