package ru.yandex.partner.libs.tvm;

import java.util.Optional;
import java.util.function.Consumer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;

import ru.yandex.passport.tvmauth.TvmClient;

public class TvmService {

    private final TvmClient tvmClient;

    @Autowired
    public TvmService(TvmClient tvmClient) {
        this.tvmClient = tvmClient;
    }

    /**
     * Выписывает тикет для данного сервис-алиаса
     * и добавляет его в хедер запрос
     * https://wiki.yandex-team.ru/passport/tvm2/theory/#serviceticket
     * @param alias https://wiki.yandex-team.ru/passport/tvm2/tvm-daemon#opisaniepolejj
     */
    public Consumer<HttpHeaders> attachTicketHeader(String alias) {
        String ticket = Optional.ofNullable(alias)
                .map(tvmClient::getServiceTicketFor)
                .orElseThrow(() -> new IllegalArgumentException("TVM Service alias can't be null"));

        return headers -> headers.add(TvmHeaders.SERVICE_TICKET_HEADER_NAME, ticket);
    }
}
