package ru.yandex.partner.unifiedagent;

import java.util.Set;

import com.google.protobuf.ByteString;

public class LogbrokerDtoValidator {
    private final Set<String> allowedTopics;
    private final int maxMessageSize;

    public LogbrokerDtoValidator(Set<String> allowedTopics, int maxMessageSize) {
        this.allowedTopics = allowedTopics;
        this.maxMessageSize = maxMessageSize;
    }


    /**
     * @param logbrokerDto message
     * @return null if valid, else text of error
     */
    public String validate(LogbrokerDto logbrokerDto) {
        String topic = logbrokerDto.getTopic();

        if (topic == null || !allowedTopics.contains(topic)) {
            return "Topic is no allowed. Topic name = " + topic;
        }

        if (logbrokerDto.getMessages() == null || logbrokerDto.getMessages().isEmpty()) {
            return "Payload cannot be empty";
        }

        for (ByteString message : logbrokerDto.getMessages()) {
            if (message.size() > maxMessageSize) {
                return "Too big message. MaxSize = " + maxMessageSize + " CurSize = " + message.size();
            }
        }

        return null;
    }
}
