package ru.yandex.partner.unifiedagent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

@Configuration
@ComponentScan(basePackages = {"ru.yandex.partner.unifiedagent"})
public class UnifiedAgentConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedAgentConfig.class);

    @Bean
    public UnifiedAgentService unifiedAgentService(
            UnifiedAgentProperties unifiedAgentProperties,
            MetricRegistry metricRegistry
    ) {
        if (unifiedAgentProperties.isEnabled()) {
            return new SimpleUnifiedAgentService(unifiedAgentProperties, metricRegistry);
        } else {
            LOGGER.info("Unified agent is disabled!");
            return dto -> UnifiedAgentResult.ok();
        }
    }
}
