package ru.yandex.partner.unifiedagent;

import java.util.Set;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "unified-agent")
public class UnifiedAgentProperties {
    private String host;
    private int port;
    @Value("${unified-agent.max.inflight.bytes}")
    private long maxInflightBytes;
    @Value("${unified-agent.max.message.size.bytes}")
    private int maxMessageSizeBytes;
    @Value("${unified-agent.close.timeout.millis}")
    private int closeTimeoutMillis;
    @Value("${unified-agent.reconnect.delay.millis}")
    private int reconnectDelayMillis;
    private int segmentSize;
    @Value("${unified-agent.minAckDelay.millis}")
    private int minAckDelayMillis;
    private String environment;
    private Set<String> topics;
    private boolean enabled = true;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getMaxInflightBytes() {
        return maxInflightBytes;
    }

    public void setMaxInflightBytes(long maxInflightBytes) {
        this.maxInflightBytes = maxInflightBytes;
    }

    public int getMaxMessageSizeBytes() {
        return maxMessageSizeBytes;
    }

    public void setMaxMessageSizeBytes(int maxMessageSizeBytes) {
        this.maxMessageSizeBytes = maxMessageSizeBytes;
    }

    public int getCloseTimeoutMillis() {
        return closeTimeoutMillis;
    }

    public void setCloseTimeoutMillis(int closeTimeoutMillis) {
        this.closeTimeoutMillis = closeTimeoutMillis;
    }

    public int getReconnectDelayMillis() {
        return reconnectDelayMillis;
    }

    public void setReconnectDelayMillis(int reconnectDelayMillis) {
        this.reconnectDelayMillis = reconnectDelayMillis;
    }

    public int getSegmentSize() {
        return segmentSize;
    }

    public void setSegmentSize(int segmentSize) {
        this.segmentSize = segmentSize;
    }

    public int getMinAckDelayMillis() {
        return minAckDelayMillis;
    }

    public void setMinAckDelayMillis(int minAckDelayMillis) {
        this.minAckDelayMillis = minAckDelayMillis;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Set<String> getTopics() {
        return topics;
    }

    public void setTopics(Set<String> topics) {
        this.topics = topics;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String toString() {
        return "UnifiedAgentProperties{" +
                "host='" + host + '\'' +
                ", port=" + port +
                ", maxInflightBytes=" + maxInflightBytes +
                ", maxMessageSizeBytes=" + maxMessageSizeBytes +
                ", closeTimeoutMillis=" + closeTimeoutMillis +
                ", reconnectDelayMillis=" + reconnectDelayMillis +
                ", segmentSize=" + segmentSize +
                ", minAckDelayMillis=" + minAckDelayMillis +
                ", environment='" + environment + '\'' +
                ", topics=" + topics +
                ", enabled=" + enabled +
                '}';
    }
}

