package ru.yandex.partner.unifiedagent;

public class UnifiedAgentResult {
    private final Status status;
    private final String details;

    private UnifiedAgentResult(Status status, String details) {
        this.status = status;
        this.details = details;
    }

    public Status getStatus() {
        return status;
    }

    public String getDetails() {
        return details;
    }

    public static UnifiedAgentResult ok() {
        return new UnifiedAgentResult(Status.OK, null);
    }

    public static UnifiedAgentResult validationError(String details) {
        return new UnifiedAgentResult(Status.VALIDATION_ERROR, details);
    }

    public enum Status {
        OK,
        VALIDATION_ERROR
    }
}
