package ru.yandex.partner.unifiedagent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

@TestConfiguration
public class UnifiedAgentTestConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedAgentTestConfig.class);

    @Bean
    public UnifiedAgentService unifiedAgentService() {
        var service = mock(UnifiedAgentService.class);

        when(service.sendToLogbroker(any())).then(invocation -> {
            LOGGER.info(
                    "{} send method was called with args: {}",
                    service.getClass(),
                    invocation.getArgument(0)
            );

            return UnifiedAgentResult.ok();
        });

        return service;
    }
}
