package ru.yandex.partner.libs.utils;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

public class BooleanToLongSerializer extends StdScalarSerializer<Boolean> {
    public BooleanToLongSerializer() {
        this(null);
    }

    public BooleanToLongSerializer(Class<Boolean> t) {
        super(t);
    }

    @Override
    public void serialize(Boolean value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else {
            gen.writeNumber(value ? 1 : 0);
        }
    }
}
