package ru.yandex.partner.libs.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.jooq.EnumType;

public class EnumTypeFromLiteralDeserializer<T extends Enum<T> & EnumType> extends StdDeserializer<T> {

    private final Map<String, T> literalMap;

    public EnumTypeFromLiteralDeserializer(Class<T> enumClazz) {
        super(enumClazz);
        this.literalMap = Arrays.stream(_valueClass.getEnumConstants())
                .map(en -> (T) en)
                .collect(Collectors.toMap(EnumType::getLiteral, Function.identity()));
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String literal = p.readValueAs(String.class);
        if (literal == null) {
            return null;
        }

        T enumValue = literalMap.get(literal);
        if (enumValue != null) {
            return enumValue;
        }

        return (T) ctxt.handleWeirdStringValue(_valueClass, literal, "Unknown literal");
    }
}
