package ru.yandex.partner.libs.utils;


import java.io.IOException;
import java.util.Objects;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.jooq.EnumType;

public class EnumTypeSerializer extends JsonSerializer<EnumType> {
    @Override
    public void serialize(EnumType value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (Objects.isNull(value)) {
            gen.writeNull();
        } else {
            gen.writeString(value.getLiteral());
        }
    }
}
