package ru.yandex.partner.libs.utils;

import java.io.IOException;
import java.util.Set;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class LongToBooleanDeserializer extends StdScalarDeserializer<Boolean> {
    private static final Set<Integer> BOOLEAN_INTEGERS = Set.of(0, 1);

    public LongToBooleanDeserializer() {
        this(Boolean.class);
    }

    public LongToBooleanDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT) && BOOLEAN_INTEGERS.contains(p.getIntValue())) {
            return p.getIntValue() == 1;
        }

        return null;
    }
}
