package ru.yandex.partner.libs.utils;

import java.util.stream.Stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class BooleanCompatModuleTest {

    private ObjectMapper mapper = new ObjectMapper().registerModule(new BooleanCompatModule());

    public static Stream<Arguments> getCases() {
        return Stream.of(
                // simple json tokens
                Arguments.arguments("null", null),
                // booleans
                Arguments.arguments("true", true),
                Arguments.arguments("false", false),
                // numbers
                Arguments.arguments("1", true),
                Arguments.arguments("0", false),
                Arguments.arguments("-1", true),
                // string-booleans
                Arguments.arguments("\"true\"", true),
                Arguments.arguments("\"false\"", false),
                // string-numbers
                Arguments.arguments("\"1\"", true),
                Arguments.arguments("\"0\"", false),
                Arguments.arguments("\"-1\"", true)
        );
    }

    @MethodSource("getCases")
    @ParameterizedTest
    public void parseBoxedBooleans(String payload, Boolean expectedValue) throws JsonProcessingException {
        Assertions.assertEquals(expectedValue, mapper.readValue(payload, Boolean.class));
    }

    @MethodSource("getCases")
    @ParameterizedTest
    public void parseUnboxedBooleans(String payload, Boolean expectedValue) throws JsonProcessingException {
        Assertions.assertEquals(expectedValue, mapper.readValue(payload, boolean.class));
    }
}
