package ru.yandex.partner.scripts.duplicate;

import org.apache.commons.cli.Option;

public enum DuplicateCliOptions {
    REF_URL(new Option("ref_url", true, "Reference url (http://localhost:8080/restapi)")),
    TEST_URL(new Option("test_url", true, "Tested url (http://localhost:8080/restapi)")),
    FILTER(new Option("filter", true,
            "Jsonapi filter. Examples: 1. [\"page_id\", \"=\", \"1\"], 2. [\"multistate\", \"=\", \"working\"]")),
    OUTPUT_DIR(new Option("output_dir", true, "Directory for output result")),
    HEADER(new Option("H", "header", true, "Additional headers. For example Auth Headers")),
    START(new Option("start", true, "Initial page start (default 1))")),
    LIMIT(new Option("limit", true, "Get partition (max 1000)")),
    COUNT(new Option("count", true, "All partition"));

    private final Option option;

    DuplicateCliOptions(Option option) {
        this.option = option;
    }

    public Option getOption() {
        return option;
    }
}
