package ru.yandex.partner.simplerest;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.web.servlet.MockMvc;

import static org.mockito.Mockito.mock;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@ExtendWith(SpringExtension.class)
@SpringBootTest(
        properties = "spring.main.allow-bean-definition-overriding=true",
        classes = {SimpleRestServiceApp.class}
        )
@AutoConfigureMockMvc
class ControllerTest {
    @Autowired
    MockMvc mvc;

    @Test
    void helloPetyaTest() throws Exception {
        Controller mock = mock(Controller.class);
        mvc.perform(get("/hello/petya"))
                .andExpect(status().isOk())
                .andExpect(content().json("{\"a\":\"petya\",\"b\":\"2353\"}"));
    }
}
