use strict;
use warnings FATAL => 'all';

use Test::More;

# Using Test::Differences if this module is installed or using
# default Test::More sub
BEGIN {
    if (!eval q{ use Test::Differences; 1 }) {
        *eq_or_diff = \&is_deeply;
    }
}

use Yandex::Tanker;

my $original_po = <<'EOT';
# This file was generated by Yandex.Tanker project.
msgid ""
msgstr ""
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"

#: lib/Application/Model/Product/InternalContextOnSite/RTB.pm:97
msgctxt "RTB block"
msgid "New"
msgstr "New"

#: lib/Application/Model/Product/InternalContextOnSite/RTB.pm:58
msgid "Roles"
msgstr "Roles"

#: framework_yndx/lib/QBit/templates/common/form/radio.bem.tt2:8
#: framework_yndx/lib/QBit/templates/common/form/input.bem.tt2:39
#: framework_yndx/lib/QBit/templates/common/form/select.bem.tt2:23
#: framework_yndx/lib/QBit/templates/common/form/textarea.bem.tt2:26
msgid "optional"
msgstr "optional"

#: lib/Application/Model/Users.pm:105
msgid "Roles"
msgstr "Roles"

#: lib/Application/Model/Users.pm:118 lib/Application/Model/DSP.pm:99
#: lib/Application/Model/Campaign/Context.pm:29
#: lib/Application/Model/Product/Distribution/Set.pm:213
#: lib/Application/Model/Product/Distribution/Download.pm:118
msgid "New"
msgstr "New"
EOT

my $fixed_po = <<'EOT';
# This file was generated by Yandex.Tanker project.
msgid ""
msgstr ""
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"

#: lib/Application/Model/Product/InternalContextOnSite/RTB.pm:97
msgctxt "RTB block"
msgid "New"
msgstr "New"

#: lib/Application/Model/Users.pm:105
#: lib/Application/Model/Product/InternalContextOnSite/RTB.pm:58
msgid "Roles"
msgstr "Roles"

#: framework_yndx/lib/QBit/templates/common/form/radio.bem.tt2:8
#: framework_yndx/lib/QBit/templates/common/form/input.bem.tt2:39
#: framework_yndx/lib/QBit/templates/common/form/select.bem.tt2:23
#: framework_yndx/lib/QBit/templates/common/form/textarea.bem.tt2:26
msgid "optional"
msgstr "optional"

#: lib/Application/Model/Users.pm:118 lib/Application/Model/DSP.pm:99
#: lib/Application/Model/Campaign/Context.pm:29
#: lib/Application/Model/Product/Distribution/Set.pm:213
#: lib/Application/Model/Product/Distribution/Download.pm:118
msgid "New"
msgstr "New"
EOT

my $yt = Yandex::Tanker->new({
    url => 'mememe',
    project => 'sample',
});

my $got = $yt->_fix_po_from_tanker($original_po);

eq_or_diff(
    $got,
    $fixed_po,
    "_fix_po_from_tanker()",
);

done_testing();
