use Test::More;

# Using Test::Differences if this module is installed or using
# default Test::More sub
BEGIN {
    if (!eval q{ use Test::Differences; 1 }) {
        *eq_or_diff = \&is_deeply;
    }
}

use Yandex::Tanker;


my $tests = [
    {
        block => q{#: lib/Application/Model/Users.pm:105
msgid "Roles"
msgstr "Roles"
},
        comment => q{#: lib/Application/Model/Users.pm:105
},
    },
    {
        block => q{#: lib/Application/Model/Users.pm:118 lib/Application/Model/DSP.pm:99
#: lib/Application/Model/Campaign/Context.pm:29
#: lib/Application/Model/Product/Distribution/Set.pm:213
#: lib/Application/Model/Product/Distribution/Download.pm:118
msgid "New"
msgstr "New"
},
        comment => q{#: lib/Application/Model/Users.pm:118 lib/Application/Model/DSP.pm:99
#: lib/Application/Model/Campaign/Context.pm:29
#: lib/Application/Model/Product/Distribution/Set.pm:213
#: lib/Application/Model/Product/Distribution/Download.pm:118
},
    },
];

my $yt = Yandex::Tanker->new({
    url => 'mememe',
    project => 'sample',
});

foreach my $t (@{$tests}) {
    my $got = $yt->_get_comment_from_block($t->{block});
    eq_or_diff(
        $got,
        $t->{comment},
        '_get_comment_from_block()',
    );
}

done_testing();
