use strict;
use warnings;

use Test::More;

use Yandex::Wiki;
use HTTP::Tiny;

sub not_found {
    my $wiki = Yandex::Wiki->new(
        oauth_token => 'token',
    );

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::request'} = sub {
        return {
            content => q/{"debug":{"hostname":"sas1-9618ca661d1f.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":118,"method":"GET","page":null,"view":"wiki.api_frontend.views.pages.RawPageView"},"error":{"debug_message":"Http404('Page cannot be found',)","message":["Page cannot be found"],"error_code":"NOT_FOUND"},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}/,
            headers => {
                allow => 'GET, HEAD, OPTIONS',
                connection => 'close',
                'content-language' => 'ru',
                'content-type' => 'application/json',
                date => 'Thu, 23 Mar 2017 19:06:54 GMT',
                server => 'nginx',
                'set-cookie' => 'uid=Bf/we1jUHM5gKk2FAxxPAg==; path=/',
                'transfer-encoding' => 'chunked',
                vary => 'Accept, Accept-Language',
                'x-qloud-router' => 'router.iva1-0002.qloud-c.yandex.net',
            },
            protocol => 'HTTP/1.1',
            reason => 'Not Found',
            status => 404,
            success => '',
        };
    };

    eval {
        my $content = $wiki->get_page('/no/such/page/');
    };

    like($@, qr/^NOT_FOUND /);
}

sub no_access {
    my $wiki = Yandex::Wiki->new(
        oauth_token => 'token',
    );

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::request'} = sub {
        return {
            content => '{"debug":{"hostname":"sas1-55323927d91b.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":239,"method":"GET","page":"ivanbessarabov","view":"wiki.api_frontend.views.pages.RawPageView"},"error":{"debug_message":"user has no access to resource","message":["User is not in the ACL for requested page"],"error_code":"USER_HAS_NO_ACCESS"},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}',
            headers => {
                allow => 'GET, HEAD, OPTIONS',
                connection => 'close',
                'content-language' => 'ru',
                'content-type' => 'application/json',
                date => 'Thu, 23 Mar 2017 19:12:36 GMT',
                server => 'nginx',
                'set-cookie' => 'uid=Bf/we1jUHiROCmBIAxbZAg==; path=/',
                'transfer-encoding' => 'chunked',
                vary => 'Accept, Accept-Language',
                'x-qloud-router' => 'router.sas1-0007.qloud-c.yandex.net',
            },
            protocol => 'HTTP/1.1',
            reason => 'Forbidden',
            status => 403,
            success => '',
        };
    };

    eval {
        my $content = $wiki->get_page('/IvanBessarabov/');
    };

    like($@, qr/^USER_HAS_NO_ACCESS /);
}

sub invalid_data {
    my $wiki = Yandex::Wiki->new(
        oauth_token => 'token',
    );

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::request'} = sub {
        return {
            content => '{"debug":{"hostname":"i-f356664662b3.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":418,"method":"GET","page":"partner/w","view":"wiki.api_frontend.views.pages.RawPageView"},"error":{"debug_message":"Client sent invalid data","errors":{"revision":["Выберите корректный вариант. Вашего варианта нет среди допустимых значений."]},"error_code":"CLIENT_SENT_INVALID_DATA"},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}',
            headers => {
                allow => 'GET, HEAD, OPTIONS',
                connection => 'close',
                'content-language' => 'ru',
                'content-type' => 'application/json',
                date => 'Thu, 23 Mar 2017 19:17:51 GMT',
                server => 'nginx',
                'set-cookie' => 'uid=Bf/we1jUH19NbmBAAx48Ag==; path=/',
                'transfer-encoding' => 'chunked',
                'vary' => 'Accept, Accept-Language',
                'x-qloud-router' => 'router.iva1-0002.qloud-c.yandex.net',
            },
            protocol => 'HTTP/1.1',
            reason => 'Conflict',
            status => 409,
            success => '',
        };
    };

    eval {
        $wiki->get_page_revision('/partner/w', 1024545245);
    };

    like($@, qr/^CLIENT_SENT_INVALID_DATA /);
}

sub main_in_test {
    pass('Loaded ok');

    not_found();
    no_access();
    invalid_data();

    done_testing();
}
main_in_test();
