use strict;
use warnings;

use Test::More;

use Yandex::Wiki;
use HTTP::Tiny;

no strict 'refs';
no warnings 'redefine';
local *{'HTTP::Tiny::request'} = sub {
    return {
        content => '{"debug":{"hostname":"myt2-6f1f38bed4c3.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":152,"method":"GET","page":"partner/w/frontend","view":"wiki.api_frontend.views.tree.TreeView"},"data":{"subpages_count":3,"expand_all_url":"https://wiki.yandex-team.ru/_api/frontend/partner/w/frontend/.tree?sort=asc&sort_by=title&depth=0&show_grids=True&show_owners=False&show_modified_at=False&show_redirects=False&show_titles=True&show_files=False&show_created_at=False","subpages":[{"subpages_count":0,"subpages":[],"page":{"url":"/partner/w/frontend/release","cluster":"release","type":"P","title":"Сборка релиза фронтенда PI2"}},{"subpages_count":0,"subpages":[],"page":{"url":"/partner/w/frontend/statistics","cluster":"statistics","type":"P","title":"Статистика"}}],"page":{"url":"/partner/w/frontend","cluster":"frontend","type":"P","title":"Все про frontend партнерского интерфейса (PI2)"},"limit_exceeded":false},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}',
        headers => {
            allow => 'GET, HEAD, OPTIONS',
            connection => 'close',
            'content-language' => 'ru',
            'content-type' => 'application/json',
            date => 'Thu, 23 Mar 2017 18:31:51 GMT',
            server => 'nginx',
            'set-cookie' => 'uid=Bf/we1jUFJdg0k2NAxj7Ag==; path=/',
            'transfer-encoding' => 'chunked',
            vary => 'Accept, Accept-Language',
            'x-qloud-router' => 'router.pool08f.qloud-c.yandex.net',
        },
        protocol => 'HTTP/1.1',
        reason => 'OK',
        status => 200,
        success => 1,
    };
};

my $wiki = Yandex::Wiki->new(
    oauth_token => 'token',
);

my @children = $wiki->get_children('/partner/w/frontend/');

is_deeply(
    \@children,
    [
        '/partner/w/frontend/release',
        '/partner/w/frontend/statistics',
    ],
);

done_testing;
