use strict;
use warnings;
use utf8;

use Test::More;

use Yandex::Wiki;
use HTTP::Tiny;
use Encode;

no strict 'refs';
no warnings 'redefine';
local *{'HTTP::Tiny::request'} = sub {
    my $response = {
        content => '{"debug":{"hostname":"fol3-e56ffca862bf.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":181,"method":"GET","page":"partner/w","view":"wiki.api_frontend.views.pages.RawPageView"},"data":{"body":"== Википедия о партнерском интерфейсе\n\n{{tree}}","version":"49418631","title":"Вики о партнерском интерфейсе"},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}',
        headers => {
            allow => 'GET, HEAD, OPTIONS',
            connection => 'close',
            'content-language' => 'ru',
            'content-type' => 'application/json',
            date => 'Thu, 23 Mar 2017 18:56:49 GMT',
            server => 'nginx',
            'set-cookie' => 'uid=Bf/we1jUGnFg0k2NAxnnAg==; path=/',
            'transfer-encoding' => 'chunked',
            vary => 'Accept, Accept-Language',
            'x-qloud-router' => 'router.pool33e.qloud-c.yandex.net',
        },
        protocol => 'HTTP/1.1',
        reason => 'OK',
        status => 200,
        success => 1,
    };

    Encode::_utf8_off($response->{content});

    return $response;
};

my $wiki = Yandex::Wiki->new(
    oauth_token => 'token',
);

my $content = $wiki->get_page_revision('/partner/w', 2905808);

is($content, '== Википедия о партнерском интерфейсе

{{tree}}');

done_testing;
