use strict;
use warnings;

use Test::More;

use Yandex::Wiki;
use HTTP::Tiny;
use JSON::PP;
use utf8;
use open qw(:std :utf8);
use Encode;

no strict 'refs';
no warnings 'redefine';
local *{'HTTP::Tiny::request'} = sub {
    my $response = {
        content => '{"debug":{"hostname":"fol3-5b7467e24714.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":110,"method":"GET","page":"partner/w/templates","view":"wiki.api_frontend.views.revisions.RevisionListView"},"data":{"total":4,"data":[{"id":6666857,"created_at":"2013-09-26T16:13:19","author":{"uid":1120000000011789,"login":"nafania","first_name":"Татьяна","last_name":"Чекина","display":"Татьяна Чекина","email":"nafania@yandex-team.ru","is_admin":false,"is_external_employee":false,"is_dismissed":false}},{"id":45958552,"created_at":"2013-09-26T16:13:19","author":{"uid":1120000000011789,"login":"nafania","first_name":"Татьяна","last_name":"Чекина","display":"Татьяна Чекина","email":"nafania@yandex-team.ru","is_admin":false,"is_external_employee":false,"is_dismissed":false}},{"id":5692838,"created_at":"2013-09-26T16:13:19","author":{"uid":1120000000011789,"login":"nafania","first_name":"Татьяна","last_name":"Чекина","display":"Татьяна Чекина","email":"nafania@yandex-team.ru","is_admin":false,"is_external_employee":false,"is_dismissed":false}},{"id":4945909,"created_at":"2013-09-26T16:13:19","author":{"uid":1120000000011789,"login":"nafania","first_name":"Татьяна","last_name":"Чекина","display":"Татьяна Чекина","email":"nafania@yandex-team.ru","is_admin":false,"is_external_employee":false,"is_dismissed":false}}]},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}',
        headers => {
            allow => 'GET, HEAD, OPTIONS',
            connection => 'close',
            'content-language' => 'ru',
            'content-type' => 'application/json',
            date => 'Thu, 23 Mar 2017 18:43:05 GMT',
            server => 'nginx',
            'set-cookie' => 'uid=Bf/we1jUFzlIv+yDAyEIAg==; path=/',
            'transfer-encoding' => 'chunked',
            vary => 'Accept, Accept-Language',
            'x-qloud-router' => 'router.fol1-0023.qloud-c.yandex.net',
        },
        protocol => 'HTTP/1.1',
        reason => 'OK',
        status => 200,
        success => 1,
    };

    Encode::_utf8_off($response->{content});

    return $response;
};

my $wiki = Yandex::Wiki->new(
    oauth_token => 'token',
);

my @r = $wiki->get_revisions('/partner/w/templates/');

is_deeply(
    \@r,
    [
        {
            author => {
                display => 'Татьяна Чекина',
                email => 'nafania@yandex-team.ru',
                first_name => 'Татьяна',
                is_admin => 0,
                is_dismissed => 0,
                is_external_employee => 0,
                last_name => 'Чекина',
                login => 'nafania',
                uid => 1120000000011789,
            },
            created_at => '2013-09-26T16:13:19',
            id => 6666857,
        },
        {
            author => {
                display => 'Татьяна Чекина',
                email => 'nafania@yandex-team.ru',
                first_name => 'Татьяна',
                is_admin => 0,
                is_dismissed => 0,
                is_external_employee => 0,
                last_name => 'Чекина',
                login => 'nafania',
                uid => 1120000000011789,
            },
            created_at => '2013-09-26T16:13:19',
            id => 45958552,
        },
        {
            author => {
                display => 'Татьяна Чекина',
                email => 'nafania@yandex-team.ru',
                first_name => 'Татьяна',
                is_admin => 0,
                is_dismissed => 0,
                is_external_employee => 0,
                last_name => 'Чекина',
                login => 'nafania',
                uid => 1120000000011789,
            },
            created_at => '2013-09-26T16:13:19',
            id => 5692838,
        },
        {
            author => {
                display => 'Татьяна Чекина',
                email => 'nafania@yandex-team.ru',
                first_name => 'Татьяна',
                is_admin => 0,
                is_dismissed => 0,
                is_external_employee => 0,
                last_name => 'Чекина',
                login => 'nafania',
                uid => 1120000000011789,
            },
            created_at => '2013-09-26T16:13:19',
            id => 4945909,
        },
    ],
);

done_testing;
