use strict;
use warnings;

use Test::More;

use HTTP::Tiny;
use Yandex::Wiki;

use JSON::PP;

local $JSON::PP::true = 1;
local $JSON::PP::false = 0;

my $raw_content = '{"debug":{"hostname":"sas1-923c21165587.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":319,"method":"GET","page":"tmp/sandbox","view":"wiki.api_frontend.views.pages.RawPageView"},"data":{"body":"Test page content","version":"51016688","title":"Page title"},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}';

my $expected_content = decode_json $raw_content;

no strict 'refs';
no warnings 'redefine';
local *{'HTTP::Tiny::request'} = sub {
    return {
        content => $raw_content,
        headers => {
            allow => 'GET, HEAD, OPTIONS',
            connection => 'close',
            'content-language' => 'ru',
            'content-type' => 'application/json',
            date => 'Thu, 23 Mar 2017 18:25:24 GMT',
            server => 'nginx',
            'set-cookie' => 'uid=Bf/we1jUExRNX2A/AxQCAg==; path=/',
            'transfer-encoding' => 'chunked',
            vary => 'Accept, Accept-Language',
            'x-qloud-router' => 'router.sas1-0015.qloud-c.yandex.net',
        },
        protocol => 'HTTP/1.1',
        reason => 'OK',
        status => 200,
        success => 1,
    };
};

my $wiki = Yandex::Wiki->new(
    oauth_token => 'token',
);

my $content = $wiki->rest_get_page('/tmp/Sandbox/');

is_deeply($content, $expected_content);

done_testing;
