use strict;
use warnings;

use Test::More;

use HTTP::Tiny;
use Yandex::Wiki;
use JSON::PP;

no strict 'refs';
no warnings 'redefine';
local *{'HTTP::Tiny::request'} = sub {
    return {
        content => '{"debug":{"hostname":"i-58a26956457c.qloud-c.yandex.net","app_name":"wiki","app_version":"development","exec_duration":1303,"method":"POST","page":"tmp/sandbox","view":"wiki.api_frontend.views.pages.PageView"},"data":{"page_type":"article","is_redirect":false,"breadcrumbs":[{"tag":"tmp","url":"/tmp","title":"tmp","is_active":true},{"tag":"tmp/Sandbox","url":"/tmp/Sandbox","title":"Page title","is_active":true}],"formatter_version":"33.0","owner":{"uid":1120000000005558,"login":"bessarabov","first_name":"Иван","last_name":"Бессарабов","display":"Иван Бессарабов","email":"bessarabov@yandex-team.ru","is_admin":false,"is_external_employee":false,"is_dismissed":false},"last_author":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false},"access":{"type":"inherited","parent_access":"common","opened_to_external_flag":false},"current_user_subscription":"none","version":"51016688","toc":{"content":[{"wiki-attrs":{"page":"/tmp/Sandbox"},"block":"wiki-toc"}],"wiki-attrs":{"lang":"ru","page_path":"/tmp/Sandbox","mode":"view","env":"production","code_theme":"github"},"block":"wiki-doc"},"subpages_count":0,"user_css":null,"bookmark":null,"is_official":false,"created_at":"2013-09-24T14:48:34","modified_at":"2017-03-23T21:15:01","actuality_status":"actual","tag":"tmp/Sandbox","supertag":"tmp/sandbox","url":"/tmp/Sandbox","title":"Page title","lang":"","qr_url":"https://disk.yandex.net/qr/?text=https%3A%2F%2Fwiki.yandex-team.ru%2Ftmp%2FSandbox%3FLgs7ZzF%252BPm0mc01IJyA6LLEZgjQ8BG8alAe1lyY%252BG%252BDdS1FFYugwIxoLJA%253D%253D","comments_count":0,"bemjson":{"content":[{"content":[{"wiki-attrs":{"txt":"Test page content","pos_start":0,"pos_end":17},"block":"wiki-txt"}],"wiki-attrs":{"pos_end":17,"pos_start":0},"block":"wiki-p"}],"wiki-attrs":{"lang":"ru","pos_end":17,"env":"production","code_theme":"github","page_path":"/tmp/Sandbox","mode":"view","display_section_anchors":true,"pos_start":0},"block":"wiki-doc"}},"user":{"uid":1120000000025712,"login":"robot-rpc-partner","first_name":"robot-rpc-partner","last_name":"robot-rpc-partner","display":"robot-rpc-partner robot-rpc-partner","email":"robot-rpc-partner@yandex-team.ru","is_admin":false,"is_external_employee":true,"is_dismissed":false,"settings":{"use_full_width_content":false,"use_nodejs_frontend":true,"code_theme":"github","propose_content_translation":false}}}',
        headers => {
            allow => 'GET, POST, DELETE, HEAD, OPTIONS',
            connection => 'close',
            'content-language' => 'ru',
            'content-type' => 'application/json',
            date => 'Thu, 23 Mar 2017 18:15:02 GMT',
            server => 'nginx',
            'set-cookie' => 'uid=Bf/we1jUEKZOCmBIAxT9Ag==; path=/',
            'transfer-encoding' => 'chunked',
            vary => 'Accept, Accept-Language',
            'x-qloud-router' => 'router.iva1-0004.qloud-c.yandex.net',
        },
        protocol => 'HTTP/1.1',
        reason => 'OK',
        status => 200,
        success => 1,
    };
};

my $wiki = Yandex::Wiki->new(
    oauth_token => 'token',
);

my $result = $wiki->save_page(
    url => '/tmp/Sandbox',
    title => 'Page title',
    content => 'Test page content',
);

is($result, '');

done_testing;
