use Test::More;
use Test::Deep;
use Test::Mojo;
use File::Slurp;
use JSON::XS;
use Moment;

$ENV{BETA_HOST} = 'docker';

require "app.psgi";

my $t = Test::Mojo->new;
$t->ua->max_redirects(1);

my $log_file_name = sprintf '/local/creator/log/api.%s.jsonl', Moment->now()->get_d();
note 'rm logs';
`cat /dev/null > $log_file_name`;

$t->get_ok('/api/3/betas/')->status_is(200);
$t->get_ok('/api/3/betas/8501')->status_is(200);

my @content = read_file $log_file_name;

cmp_deeply(
    decode_json($content[0]),
    {
        code => 200,
        elapsed => ignore(),
        has_login => JSON::XS::false,
        ip => undef,
        method => 'GET',
        timestamp => ignore(),
        url => '/api/3/betas/',
        'user-agent' => 'Mojolicious (Perl)',
    },
);

cmp_deeply(
    decode_json($content[1]),
    {
        code => 200,
        elapsed => ignore(),
        has_login => JSON::XS::false,
        ip => undef,
        method => 'GET',
        timestamp => ignore(),
        url => '/api/3/betas/8501',
        'user-agent' => 'Mojolicious (Perl)',
    },
);

like($content[0], qr'{"code":200,"elapsed":.*,"has_login":false,"ip":null,"method":"GET","timestamp":".*","url":"/api/3/betas/","user-agent":"Mojolicious \(Perl\)"}');
like($content[1], qr'{"code":200,"elapsed":.*,"has_login":false,"ip":null,"method":"GET","timestamp":".*","url":"/api/3/betas/8501","user-agent":"Mojolicious \(Perl\)"}');

done_testing();
