use strict;
use warnings FATAL => 'all';

use Test::More;
use File::Temp;
use File::Slurp;

use lib::abs qw(
    ../lib
);
use Utils;

sub main_in_test {
    pass('Loaded ok');

    my $file_name = '/tmp/change_file_content_test';
    unlink($file_name);

    write_file(
        $file_name,
        {
            binmode => ':utf8',
        },
        "line 1\nline 2\n",
    );

    change_file_content(
        file_name => $file_name,
        changer => sub {
            my ($content, $string) = @_;

            my $output;
            foreach my $line (split /\n/, $content) {
                $line =~ s/ /$string/g;
                $output .= $line . "\n";
            }

            return $output;
        },
        opts => ['BBB'],
    );

    my $content = read_file(
        $file_name,
        {
            binmode => ':utf8',
        },
    );

    is(
        $content,
        "lineBBB1\nlineBBB2\n",
    );

    unlink($file_name);

    done_testing();
}
main_in_test();
