use Test::More;
use Test::Mojo;
use File::Slurp;
use JSON::XS;

$ENV{BETA_HOST} = 'docker';

require "app.psgi";

sub check_first_two_ports_are_free {
    my ($t) = @_;

    $t->get_ok('/api/3/betas/')
        ->status_is(200)
        ->json_is('/0' => { port => 8501, status => 'free'})
        ->json_is('/1' => { port => 8502, status => 'free'})
        ;

    $t->get_ok('/api/3/betas/8501')
        ->status_is(200)
        ->json_is({ port => 8501, status => 'free'})
        ;

    $t->get_ok('/api/3/betas/8502')
        ->status_is(200)
        ->json_is({ port => 8502, status => 'free'})
        ;
}

my $t = Test::Mojo->new;
$t->ua->max_redirects(1);

check_first_two_ports_are_free($t);

note 'creating mock for beta 8501';
write_file '/local/creator/meta/8501.json', encode_json {
    backend => 'master',
    backend_sha1 => '123',
    frontend => 'master',
    frontend_sha1 => '123',
};

my $expected_beta_data = {
    backend => 'master',
    backend_sha1 => '123',
    backend_status => 'deleted',
    frontend => 'master',
    frontend_sha1 => '123',
    frontend_status => 'deleted',
};

$t->get_ok('/api/3/betas/')
    ->status_is(200)
    ->json_is('/0' => $expected_beta_data )
    ->json_is('/1' => { port => 8502, status => 'free'})
    ;

$t->get_ok('/api/3/betas/8501')
    ->status_is(200)
    ->json_is($expected_beta_data)
    ;

$t->get_ok('/api/3/betas/8502')
    ->status_is(200)
    ->json_is({ port => 8502, status => 'free'})
    ;

note 'removing mock for beta 8501';
unlink '/local/creator/meta/8501.json';

check_first_two_ports_are_free($t);

$t->get_ok('/api/3/betas/XXX')
    ->status_is(400)
    ->json_is({ status => JSON::XS::false, error_message => 'Incorrect port'})
    ;

done_testing();
